using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public abstract class ArcanistScroll : SpellScroll
	{
		public override int LabelNumber { get { return 1031001 + SpellID; } }

		[Constructable]
		public ArcanistScroll( int spellID, int itemID, int amount ) : base( spellID, itemID, amount )
		{
            Hue = 0x8FD;
		}

      public ArcanistScroll( Serial serial ) : base( serial )
      {
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}